/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.sound;

import io.github.foundationgames.automobility.entity.AutomobileEntity;
import io.github.foundationgames.automobility.sound.AutomobilitySounds;
import net.minecraft.class_1101;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;

public abstract class AutomobileSoundInstance
extends class_1101 {
    private final class_310 client;
    private final AutomobileEntity automobile;
    private double lastDistance;
    private int fade = 0;
    private boolean die = false;

    public AutomobileSoundInstance(class_3414 sound, class_310 client, AutomobileEntity automobile) {
        super(sound, class_3419.field_15256);
        this.client = client;
        this.automobile = automobile;
        this.field_5446 = true;
        this.field_5451 = 0;
    }

    protected abstract boolean canPlay(AutomobileEntity var1);

    protected abstract float getPitch(AutomobileEntity var1);

    protected abstract float getVolume(AutomobileEntity var1);

    public void method_16896() {
        class_746 player = this.client.field_1724;
        if (this.automobile.method_31481() || player == null) {
            this.method_24876();
            return;
        }
        if (!this.canPlay(this.automobile)) {
            this.die = true;
        }
        if (this.die) {
            if (this.fade > 0) {
                --this.fade;
            } else if (this.fade == 0) {
                this.method_24876();
                return;
            }
        } else if (this.fade < 3) {
            ++this.fade;
        }
        this.field_5442 = this.getVolume(this.automobile) * (float)this.fade / 3.0f;
        this.field_5439 = this.automobile.method_23317();
        this.field_5450 = this.automobile.method_23318();
        this.field_5449 = this.automobile.method_23321();
        this.field_5441 = this.getPitch(this.automobile);
        if (player.method_5854() != this.automobile) {
            double distance = this.automobile.method_19538().method_1020(player.method_19538()).method_1033();
            this.field_5441 = (float)((double)this.field_5441 + 0.36 * Math.atan(this.lastDistance - distance));
            this.lastDistance = distance;
        } else {
            this.lastDistance = 0.0;
        }
    }

    public static class SkiddingSound
    extends AutomobileSoundInstance {
        public SkiddingSound(class_310 client, AutomobileEntity automobile) {
            super(AutomobilitySounds.SKID, client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.isDrifting() || automobile.burningOut();
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return automobile.burningOut() ? 0.75f : 1.0f + 0.056f * ((float)Math.min(automobile.getTurboCharge(), 115) / 115.0f);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return automobile.automobileOnGround() ? 1.0f : 0.0f;
        }
    }

    public static class EngineSound
    extends AutomobileSoundInstance {
        public EngineSound(class_310 client, AutomobileEntity automobile) {
            super(automobile.getEngine().sound(), client, automobile);
        }

        @Override
        protected boolean canPlay(AutomobileEntity automobile) {
            return automobile.engineRunning() || automobile.getBoostTimer() > 0;
        }

        @Override
        protected float getPitch(AutomobileEntity automobile) {
            return (float)(Math.pow(4.0, automobile.getEffectiveSpeed() - 0.9) + 0.32);
        }

        @Override
        protected float getVolume(AutomobileEntity automobile) {
            return 1.0f;
        }
    }
}

